<?php

namespace App\Http\Controllers;

use App\Model\AuditLogin;
use Illuminate\Http\Request;
use Modules\User\Entities\User;

class AuditLoginController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth:admin', 'admin.active']);
        $this->authorizeResource(AuditLogin::class, 'audit_login');
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = AuditLogin::query()
                        ->whereNull('admin_id')
                        ->with(['user'])
                        ->filters($request);

            return AuditLogin::makeDataTable($data);
        }

        return view('admin.audit-login.index', [
            'users' => User::has('filteredAuditLogins')->orderBy('name')->orderBy('email')->pluck('name', 'id'),
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(AuditLogin $audit_login)
    {
        $audit_login->delete();

        return redirect()->route('audit-login.index')->withStatus(__("Row #$audit_login->id successfully deleted."));
    }
}
