<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Api\ApiController;
use App\Model\StaticPage;
use App\Transformers\PageResource;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ShowPageController extends ApiController
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request, $slug)
    {
        $page = StaticPage::query()
            ->where('slug', $slug)
            ->active()
            ->first();

        if (!$page) {
            return $this->jsonError(Response::HTTP_NOT_FOUND, __('Page not found or invalid slug.'), reference_code: 'P001');
        }

        return $this->json((new PageResource($page))->toArray($request));
    }
}
