<?php

namespace App\Http\Controllers\Api;

use App\Model\StaticPage;
use App\Transformers\PageCollection;
use Illuminate\Http\Request;

class AllPagesController extends ApiController
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $pages = StaticPage::query()
            ->active()
            ->orderBy('position')
            // ->take(config('api.limit_results_per_request', 100))
            ->get();

        return $this->json((new PageCollection($pages))->toArray($request));
    }
}
