<?php

use App\Classes\SecureHeaders;
use Backpack\Basset\Enums\StatusEnum;
use Backpack\Basset\Facades\Basset;

if (! function_exists('basset_url')) {
    function basset_url(string $asset, array $attributes = [], bool $mix = false): string
    {
        $status = Basset::basset($asset, false, $attributes);

        if (in_array($status, [StatusEnum::DISABLED, StatusEnum::INVALID])) {
            if ($mix) {
                return url(mix($asset));
            }

            return asset($asset);
        }

        return Basset::getUrl($asset);
    }
}

if (! function_exists('basset_nonce')) {
    function basset_nonce(string $target = ''): string
    {
        $nonce = config('backpack.basset.nonce');

        SecureHeaders::addOrSkipNonce($nonce, $target);

        return $nonce;
    }
}
