<?php

namespace App\Classes;

use Illuminate\Support\Facades\Storage;
use Intervention\Image\Drivers\Gd\Driver;
use Intervention\Image\ImageManager;

/**
 * App\Classes\Uno.
 */
class Uno
{
    public $favicon;
    public $logo;
    public $logo_path;
    public $default_logo_path;
    public $og_image;
    public $og_path;
    public $avatar;
    public $avatar_path;
    public $no_image;
    public $no_video;
    public $no_result;

    public function __construct()
    {
        $this->default_logo_path = 'images/logo/logo.png';
        $this->og_path = 'images/logo/og_image.png';

        $this->setLogo($this->default_logo_path);

        $this->favicon = asset('images/logo/favicon.jpg');
        $this->avatar = asset('images/avatar/default.jpg');
        $this->avatar_path = asset('images/avatar/default.jpg');
        $this->no_image = asset('images/not-found.png');
        $this->no_video = asset('images/no-video.jpg');
        $this->no_result = asset('images/no-result.jpg');
    }

    public function setLogo($logo_path)
    {
        if (!asset_exists($logo_path)) {
            $logo_path = $this->default_logo_path;
        }

        $this->logo_path = $logo_path;

        if (filter_var($this->logo_path, FILTER_VALIDATE_URL)) {
            $this->logo = $this->logo_path;
        } else {
            $this->logo = asset($this->logo_path);
        }

        if (!asset_exists($this->og_path)) {
            try {
                $manager = new ImageManager(Driver::class);

                // NOTE: og image standard size
                $image = $manager->create(1200, 630);
                $image->place(disk_public()->path($this->logo_path), 'center');
                $image->toJpeg()->save($this->og_path);

                $this->og_image = asset($this->og_path);
            } catch (\Exception $e) {
                // report($e);
            }
        }
    }

    public function deleteOpenGraphImage()
    {
        destroy_asset($this->og_path);
    }
}
