<?php

namespace App\Classes;

use Bepsvpt\SecureHeaders\SecureHeaders as BepsvptSecureHeaders;

class SecureHeaders extends BepsvptSecureHeaders
{
    public function removeStyleNonce()
    {
        self::removeNonce('style');

        return $this;
    }

    public static function addNonce(string $nonce, string $target = 'script'): string
    {
        self::$nonces[$target][] = $nonce;

        return $nonce;
    }

    public static function hasNonce(string $nonce, string $target = 'script'): bool
    {
        return in_array($nonce, self::$nonces[$target], true);
    }

    public static function addOrSkipNonce(string $nonce, string $target = 'script'): string
    {
        if (! self::hasNonce($nonce, $target)) {
            $nonce = self::addNonce($nonce, $target);
        }

        return $nonce;
    }
}
