<?php

namespace App\Classes;

use GrahamCampbell\SecurityCore\Security;
use voku\helper\AntiXSS;

class Sanitize extends Security
{
    /**
     * Init a new Sanitize instance.
     *
     * @param array|null  $evil
     * @param array|null  $allowed
     * @param string|null $replacement
     *
     * @return \App\Classes\Sanitize
     */
    public static function init()
    {
        $antiXss = new AntiXSS();

        $evil = config('sanitize.evil');
        $allowed = config('sanitize.allowed');
        $replacement = config('sanitize.replacement');

        if ($replacement !== null) {
            $antiXss->setReplacement($replacement);
        }

        if ($evil !== null) {
            self::addOptions($antiXss, $evil);
        }

        if ($allowed !== null) {
            self::removeOptions($antiXss, $allowed);
        }

        return new self($antiXss);
    }

    /**
     * Add the given evil options.
     *
     * @param \voku\helper\AntiXSS $antiXss
     * @param array                $evil
     *
     * @return void
     */
    private static function addOptions(AntiXSS $antiXss, array $evil)
    {
        if (isset($evil['attributes'])) {
            $antiXss->addEvilAttributes($evil['attributes'] ?? []);
        }

        if (isset($evil['tags'])) {
            $antiXss->addEvilHtmlTags($evil['tags'] ?? []);
        }

        if (isset($evil['regex'])) {
            $antiXss->addNeverAllowedRegex($evil['regex'] ?? []);
        }
    }

    /**
     * Remove the given allowed evil options.
     *
     * @param \voku\helper\AntiXSS $antiXss
     * @param array                $evil
     *
     * @return void
     */
    private static function removeOptions(AntiXSS $antiXss, array $allowed)
    {
        if (isset($allowed['attributes'])) {
            $antiXss->removeEvilAttributes($allowed['attributes'] ?? []);
        }

        if (isset($allowed['tags'])) {
            $antiXss->removeEvilHtmlTags($allowed['tags'] ?? []);
        }
    }
}
