<?php

use Illuminate\Support\Facades\Route;
use Modules\User\Http\Controllers\AdminController;

Route::prefix('user')->name('user.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{user}/edit', 'edit')->name('edit');
        Route::put('{user}', 'update')->name('update');

        Route::delete('{user}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});
