@component('mail::message')
# Hello {{ $user->name }}!,

Your account has been registered by the admin.<br>
The details as per below:

@component('mail::table')
| Details |  |
| --- | --- |
| Email Address: | {{ $user->email }} |
| Password: | {{ $new_password }} |
@endcomponent

You may proceed to login with the credentials provided, complete your profile information and please change the default password.<br>

@component('mail::button', ['url' => $link])
{{ $action }}
@endcomponent

@slot('subcopy')
@lang(
    "If you’re having trouble clicking the \":actionText\" button, copy and paste the URL below\n".
    'into your web browser:',
    [
        'actionText' => $action,
    ]
) <span class="break-all">[{{ $link }}]({{ $link }})</span>
@endslot
@endcomponent
