@push('js')
    @bassetBlock('front/js/toggle-password.js')
        <script nonce="{{ basset_nonce('script') }}">
            const passwordFields = document.querySelectorAll('.toggle-password');

            passwordFields.forEach((wrapper) => {
                wrapper.classList.add('position-relative');

                let viewPasswordButton = document.createElement('button');

                viewPasswordButton.setAttribute('type', 'button');
                viewPasswordButton.className = 'btn btn-link shadow-none position-absolute top-50 end-0 translate-middle-y px-3';
                viewPasswordButton.innerHTML = '<i class="fas fa-sm fa-eye">';

                if (hasInvalid = wrapper.querySelector('.is-invalid') || wrapper.classList.contains('has-danger')) {
                    viewPasswordButton.classList.add('me-4');
                }

                wrapper.appendChild(viewPasswordButton);

                viewPasswordButton.addEventListener('click', function() {
                    if (passwordInput = wrapper.querySelector('input[type="password"]')) {
                        viewPasswordButton.innerHTML = '<i class="fas fa-sm fa-eye-slash">';
                        passwordInput.setAttribute('type', 'text');
                    } else if (textInput = wrapper.querySelector('input[type="text"]')) {
                        viewPasswordButton.innerHTML = '<i class="fas fa-sm fa-eye">';
                        textInput.setAttribute('type', 'password');
                    }
                });
            });
        </script>
    @endBassetBlock()
@endpush
