
@inject('user', Modules\User\Entities\User::class)

@extends('admin.layouts.base', [
    'title' => __('Users Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-tie fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('user.index') }}">{{ __('Users') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $user)
                <a href="{{ route('user.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $user)
                <a href="{{ route('user.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', true)
        @endcomponent

        <div class="py-4">
            <table id="tableUser" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $user)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Avatar') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Email') }}</th>
                        <th>{{ __('Contact') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        {{-- <th>{{ __('Last Login At') }}</th> --}}
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'User',
    'route' => route('user.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $user, can: ['update', 'delete']),
        get_dt_column_config('avatar', orderable: false, searchable: false),
        get_dt_column_config('name'),
        get_dt_column_config('email'),
        get_dt_column_config('contact_no'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        // get_dt_column_config('last_login_at', searchable: false),
    ]
])

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        // $("#filterCountry").on('change', function (ev) {
        //     const urlParams = new URLSearchParams(window.location.search);

        //     if ($(this).val() != 'all') {
        //         urlParams.set('country', $(this).val());
        //     } else {
        //         urlParams.delete('country');
        //     }

        //     window.location.search = urlParams;
        // });
    </script>
@endpush
