<div class="col-12 form-group">
    <label class="form-control-label" for="input-name">{{ __('Name') }}</label>
    <div class="{{ $errors->has('name') ? 'has-danger' : '' }}">
        <input type="text" name="name" id="input-name" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="{{ __('Name') }}" value="{{ old('name', $user->name) }}">
    </div>
    @include('alerts.feedback', ['field' => 'name'])
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-email">{{ __('Email') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('name') ? 'has-danger' : '' }}">
        <input type="email" name="email" id="input-email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" placeholder="{{ __('Email') }}" value="{{ old('email', $user->email) }}" required autocomplete="new-email">
    </div>
    @include('alerts.feedback', ['field' => 'email'])
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-contact_no">{{ __('Contact No.') }}</label>
    <div class="{{ $errors->has('contact_no') ? 'has-danger' : '' }}">
        <input type="tel" inputmode="numeric" name="contact_no"  id="input-contact_no" class="form-control {{ $errors->has('contact_no') ? 'is-invalid' : '' }}" placeholder="{{ __('Contact No.') }}" value="{{ old('contact_no', $user->contact_no) }}">
    </div>
    @include('alerts.feedback', ['field' => 'contact_no'])
</div>

{{-- <div class="col-md-6 form-group">
    <label class="form-control-label" for="input-gender">{{ __('Gender') }} <sup class="text-danger">*</sup></label>
    <select name="gender" id="input-gender" class="form-control {{ $errors->has('gender') ? 'is-invalid' : '' }}" placeholder="{{ __('Gender') }}" required>
        @foreach (config('gender') as $key => $label)
            <option value="{{ $key }}" {{ $key == old('gender', $user->gender) ? 'selected' : '' }}>{{ $label }}</option>
        @endforeach
    </select>
    @include('alerts.feedback', ['field' => 'gender'])
</div> --}}

@include('admin.components.fileinput', [
    'thumbnail' => [
        'delete' => asset_exists($user->picture),
        'label' => 'avatar',
        'url' => $user->avatar_path,
        'path' => $user->picture,
        'policy' => 'update',
        'entity' => $user::class,
        'hash' => $user->hash_id,
    ],
    'label' => 'Avatar',
    'name' => 'photo',
    'recommend' => '150px * 150px',
])

@isset($edit)
    <div class="col-12 form-group">
        <hr class="mb-0 mt-2">
    </div>

    <div class="col-md-6 form-group">
        <label class="form-control-label" for="input-password">{{ __('Password') }}</label>
        <div class="{{ $errors->has('password') ? 'has-danger' : '' }} toggle-password">
            <input type="password" name="password" id="input-password" class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" placeholder="{{ __('Password') }}" autocomplete="new-password">
        </div>
        @include('alerts.feedback', ['field' => 'password'])
    </div>

    <div class="col-md-6 form-group">
        <label class="form-control-label" for="input-password-confirmation">{{ __('Confirm Password') }}</label>
        <div class="{{ $errors->has('password') ? 'has-danger' : '' }} toggle-password">
            <input type="password" name="password_confirmation" id="input-password-confirmation" class="form-control" placeholder="{{ __('Confirm Password') }}" autocomplete="new-password">
        </div>
    </div>
@endisset

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Status Active') }}</label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $user->is_active) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

@push('vendor-css')
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/select2/dist/css/select2.min.css') }}" nonce="{{ csp_nonce('style') }}">
@endpush

@push('vendor-js')
    <script src="{{ basset_url('argon/vendor/select2/dist/js/select2.full.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush

@includeFirst(['admin.components.toggle-password'])
