@extends('admin.layouts.base', [
    'title' => __('Edit User'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-tie fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('user.index') }}">{{ __('Users') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('user.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit User') . ' #' . $user->id)
                    @slot('route', route('user.update', $user->hash_id))

                    @include('user::admin.form', ['user' => $user, 'edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection
