@extends('admin.layouts.base', [
    'title' => __('Create New User'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-tie fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('user.index') }}">{{ __('Users') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Create New') }}</li>

        @slot('buttons')
            <a href="{{ route('user.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('title', __('New User'))
                    @slot('route', route('user.store'))

                    @include('user::admin.form', ['user' => $user])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
