<?php

namespace Modules\User\Policies;

use Modules\Admin\Entities\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\User\Entities\User;

class UserPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate user can see the users.
     */
    public function viewAny(Admin|User $auth): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('user');
        }

        return false;
    }

    /**
     * Determine whether the authenticate user can create users.
     */
    public function create(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the authenticate user can update the user.
     */
    public function update(Admin|User $auth, User $model): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('user');
        }

        return false;
    }

    /**
     * Determine whether the authenticate user can delete the user.
     */
    public function delete(Admin|User $auth, User $model): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('user');
        }

        return false;
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|User $auth): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('user');
        }

        return false;
    }

    /**
     * Determine whether the admin can export the users.
     */
    public function export(Admin|User $auth): bool
    {
        if ($auth instanceof Admin) {
            // return $auth->hasPermission('user');
        }

        return false;
    }
}
