<?php

namespace Modules\User\Http\Requests;

use Modules\User\Entities\User;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $user = $this->route()->user;

        return [
            'name' => ['nullable', 'string'],
            'email' => ['required', 'email', Rule::unique((new User)->getTable())->ignore($user->id ?? null)],
            'password' => $this->getPasswordValidation($user),
            'contact_no' => ['nullable', 'string'],
            'photo' => file_validation($this->get('photo')),
            'is_active' => ['sometimes', 'boolean'],
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'photo' => 'avatar',
            'is_active' => 'status active',
        ];
    }

    private function getPasswordValidation($user)
    {
        $password_validation = ['string', 'confirmed', Password::defaults()];

        return array_merge([$user ? 'nullable' : 'sometimes'], $password_validation);
    }
}
