<?php

namespace Modules\User\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\Sequence;
use Illuminate\Support\Facades\Hash;
use Modules\Country\Entities\Country;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Model>
 */
class UserFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\User\Entities\User::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $country = Country::select('id', 'name')->inRandomOrder()->first();

        return [
            'name' => $name = fake()->name(),
            'email' => fake()->unique()->safeEmail,
            'contact_no' => fake()->phoneNumber(),
            'picture' => fallback_via_placeholder(fake()->imageUrl(category: $name, randomize: false)),
            'gender' => fake()->numberBetween(1, 2),
            'password' => Hash::make('password'),
            'is_active' => fake()->boolean(90),
            'email_verified_at' => now(),
            'address_line_1' => fake()->streetName(),
            'address_line_2' => fake()->streetAddress(),
            'postcode' => fake()->postcode(),
            'country_id' => $country->id,
            'country_iso' => $country->iso,
            'country_name' => $country->name,
        ];
    }

    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }

    public function main(): static
    {
        $country = Country::select('id', 'name')->inRandomOrder()->first();

        return $this->state(fn (array $attributes) => [
            'name' => $name = 'Fikrie UNO',
            'email' => 'fikrie@uno.com.my',
            'contact_no' => '01234567890',
            'picture' => fallback_via_placeholder(fake()->imageUrl(category: $name, randomize: false)),
            'gender' => fake()->numberBetween(1, 2),
            'password' => '$2y$10$rikhZ8t.5XUFpbUVW3GFouyXDm1uJ5/DTULv5VrHMPQ1npCDU2vgO',
            'is_active' => true,
            'email_verified_at' => now(),
            'address_line_1' => fake()->streetName(),
            'address_line_2' => fake()->streetAddress(),
            'postcode' => fake()->postcode(),
            'country_id' => $country->id,
            'country_iso' => $country->iso,
            'country_name' => $country->name,
        ]);
    }
}
