<?php

use Illuminate\Support\Facades\Route;
use Modules\Speaker\Http\Controllers\AdminController;

Route::prefix('speaker')->name('speaker.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{speaker}/edit', 'edit')->name('edit');
        Route::put('{speaker}', 'update')->name('update');

        Route::delete('{speaker}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});
