
@inject('speaker', Modules\Speaker\Entities\Speaker::class)

@extends('admin.layouts.base', [
    'title' => __('Speakers Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-graduate fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('speaker.index') }}">{{ __('Speakers') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('speaker.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableSpeaker" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $speaker)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Profile') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Designation') }}</th>
                        {{-- <th>{{ __('Email') }}</th> --}}
                        {{-- <th>{{ __('Contact') }}</th> --}}
                        <th>{{ __('Description') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Speaker',
    'route' => route('speaker.trashed'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $speaker, can: ['restore']),
        get_dt_column_config('avatar', orderable: false, searchable: false),
        get_dt_column_config('name'),
        get_dt_column_config('designation'),
        // get_dt_column_config('email'),
        // get_dt_column_config('contact_no'),
        get_dt_column_config('description'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
