
@inject('speaker', Modules\Speaker\Entities\Speaker::class)

@extends('admin.layouts.base', [
    'title' => __('Speakers Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-graduate fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('speaker.index') }}">{{ __('Speakers') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $speaker)
                <a href="{{ route('speaker.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $speaker)
                <a href="{{ route('speaker.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    @if (request()->has('event'))
        <h1 class="text-white mb-3">{{ __('Event #:id Speakers', ['id' => request()->query('event')]) }}</h1>
    @endif

    <div class="card">
        @component('admin.components.filter')
            @slot('status', true)

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterEvent">{{ __('Filter Event') }}</label>
                <select class="form-control" name="event" id="filterEvent" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach ($events as $id => $name)
                        <option value="{{ $id }}" @selected(request()->query('event') == $id)>{{ $name }}</option>
                    @endforeach
                </select>
            </div>
        @endcomponent

        <div class="py-4">
            <table id="tableSpeaker" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $speaker)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Profile') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Designation') }}</th>
                        {{-- <th>{{ __('Email') }}</th> --}}
                        {{-- <th>{{ __('Contact') }}</th> --}}
                        <th>{{ __('Description') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Speaker',
    'route' => route('speaker.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $speaker, can: ['update', 'delete']),
        get_dt_column_config('avatar', orderable: false, searchable: false),
        get_dt_column_config('name'),
        get_dt_column_config('designation'),
        // get_dt_column_config('email'),
        // get_dt_column_config('contact_no'),
        get_dt_column_config('description'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $("#filterEvent").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('event', $(this).val());
            } else {
                urlParams.delete('event');
            }

            window.location.search = urlParams;
        });
    </script>
@endpush
