@extends('admin.layouts.base', [
    'title' => __('Edit Speaker'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-graduate fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('speaker.index') }}">{{ __('Speakers') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('speaker.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Speaker') . ' #' . $speaker->id)
                    @slot('route', route('speaker.update', $speaker->hash_id))

                    @include('speaker::admin.form', ['speaker' => $speaker, 'edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection
