<?php

namespace Modules\Speaker\Policies;

use Modules\Admin\Entities\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\Speaker\Entities\Speaker;

class SpeakerPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate speaker can see the speakers.
     */
    public function viewAny(Admin|Speaker $auth): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('speaker');
        }

        return false;
    }

    /**
     * Determine whether the authenticate speaker can create speakers.
     */
    public function create(Admin|Speaker $auth): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('speaker');
        }

        return false;
    }

    /**
     * Determine whether the authenticate speaker can update the speaker.
     */
    public function update(Admin|Speaker $auth, Speaker $model): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('speaker');
        }

        return false;
    }

    /**
     * Determine whether the authenticate speaker can delete the speaker.
     */
    public function delete(Admin|Speaker $auth, Speaker $model): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('speaker');
        }

        return false;
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|Speaker $auth): bool
    {
        if ($auth instanceof Admin) {
            return $auth->hasPermission('speaker');
        }

        return false;
    }

    /**
     * Determine whether the admin can export the speakers.
     */
    public function export(Admin|Speaker $auth): bool
    {
        if ($auth instanceof Admin) {
            // return $auth->hasPermission('speaker');
        }

        return false;
    }
}
