<?php

namespace Modules\Speaker\Observers;

use Modules\Speaker\Entities\Speaker;

class SpeakerObserver
{
    /**
     * Handle the model "created" event.
     */
    public function created(Speaker $speaker): void
    {
        $speaker->created_by = admin()?->id;
        $speaker->saveQuietly();
    }

    /**
     * Handle the model "updated" event.
     */
    public function updated(Speaker $speaker): void
    {
        if ($speaker->wasChanged('picture')) {
            destroy_asset($speaker->getOriginal('picture'));
        }
    }

    /**
     * Handle the model "deleted" event.
     */
    public function deleted(Speaker $speaker): void
    {
        $speaker->updateQuietly([
            'is_active' => false,
            'deleted_by' => admin()?->id,
        ]);
    }

    /**
     * Handle the model "restored" event.
     */
    public function restored(Speaker $speaker): void
    {
        $speaker->updateQuietly([
            'deleted_by' => null,
        ]);
    }

    /**
     * Handle the model "force deleted" event.
     */
    public function forceDeleted(Speaker $speaker): void
    {
        destroy_asset($speaker->getOriginal('picture'));
    }
}
