<?php

namespace Modules\Speaker\Http\Requests;

use Modules\Speaker\Entities\Speaker;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class SpeakerRequest extends FormRequest
{
    /**
     * Determine if the speaker is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $speaker = $this->route()->speaker;

        return [
            'designation' => ['required', 'string', 'max:100'],
            'name' => ['required', 'string', 'max:100'],
            'email' => ['sometimes', 'nullable', 'email'],
            'contact_no' => ['sometimes', 'nullable', 'string'],
            'description' => ['required', 'string', 'max:300'],
            // 'password' => $this->getPasswordValidation($speaker),
            'photo' => file_validation($this->get('photo'), required: is_null($speaker), sometimes: false),
            'is_active' => ['sometimes', 'boolean'],
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'description' => 'profile description',
            'photo' => 'profile picture',
            'is_active' => 'status active',
        ];
    }

    private function getPasswordValidation($speaker)
    {
        $password_validation = ['string', 'confirmed', Password::defaults()];

        return array_merge([$speaker ? 'nullable' : 'sometimes'], $password_validation);
    }
}
