<?php

namespace Modules\Speaker\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\Sequence;
use Illuminate\Support\Facades\Hash;
use Modules\Country\Entities\Country;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Model>
 */
class SpeakerFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\Speaker\Entities\Speaker::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        // $country = Country::select('id', 'name')->inRandomOrder()->first();

        return [
            'name' => $name = fake()->name(),
            'designation' => fake()->catchPhrase(),
            'email' => fake()->unique()->safeEmail,
            'contact_no' => fake()->phoneNumber(),
            'description' => fake()->realText(),
            'picture' => fallback_via_placeholder(fake()->imageUrl(category: $name, randomize: false)),
            // 'gender' => fake()->numberBetween(1, 2),
            // 'password' => Hash::make('password'),
            'is_active' => fake()->boolean(60),
            'created_by' => 1,
        ];
    }
}
