<?php

use Illuminate\Support\Facades\Route;
use Modules\Participant\Http\Controllers\AdminController;

Route::prefix('participant')->name('participant.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{participant}/edit', 'edit')->name('edit');
        Route::put('{participant}', 'update')->name('update');

        Route::delete('{participant}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});