@component('mail::message')
# Hello {{ $participant->name }},

Thank you for expressing interest in <strong>{{ $event->title }}</strong>.<br>
Your registration is successful, and we are thrilled to have you on board!<br>
Your details registered as per below:

@component('mail::table')
| Details |  |
| --- | --- |
| Name: | {{ $participant->name }} |
| Designation: | {{ $participant->designation }} |
| Company Name: | {{ $participant->company }} |
| Email Address: | {{ $participant->email }} |
| Phone No.: | {{ $participant->contact_no }} |
@endcomponent

While we prepare to share more exciting updates with you, here is a summary of the information we currently have about the event:<br>

@component('mail::table')
| Event |  |
| --- | --- |
| Title: | {{ $event->title }} |
| Location: | {{ $event->location }} |
| Start Date: | {{ $event->start_date?->format('d/m/Y') }} |
| End Date: | {{ $event->end_date?->format('d/m/Y') ?: '-' }} |
@endcomponent

@if ($event->banner)
<img src="{{ $event->banner_path }}" class="banner" alt="{{ $event->title }} Banner">
@endif

@if (!empty($link))
@component('mail::button', ['url' => $link])
{{ $action }}
@endcomponent

@slot('subcopy')
@lang(
    "If you’re having trouble clicking the \":actionText\" button, copy and paste the URL below\n".
    'into your web browser:',
    [
        'actionText' => $action,
    ]
) <span class="break-all">[{{ $link }}]({{ $link }})</span>
@endslot
@endif

Please keep an eye on your inbox for updates, and feel free to reach out to us if you have any questions in the meantime.
@endcomponent
