
@inject('participant', Modules\Participant\Entities\Participant::class)

@extends('admin.layouts.base', [
    'title' => __('Participants Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-group fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('participant.index') }}">{{ __('Participants') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('participant.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableParticipant" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $participant)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Event') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Designation') }}</th>
                        <th>{{ __('Email') }}</th>
                        <th>{{ __('Phone No.') }}</th>
                        <th>{{ __('Company') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Participant',
    'route' => route('participant.trashed'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $participant, can: ['restore']),
        get_dt_column_config('event', 'event.title'),
        get_dt_column_config('name'),
        get_dt_column_config('designation'),
        get_dt_column_config('email'),
        get_dt_column_config('contact_no'),
        get_dt_column_config('company'),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
