
@inject('participant', Modules\Participant\Entities\Participant::class)

@extends('admin.layouts.base', [
    'title' => __('Participants Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-group fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('participant.index') }}">{{ __('Participants') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $participant)
                <a href="{{ route('participant.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $participant)
                <a href="{{ route('participant.export', request()->query()) }}" class="btn btn-sm btn-neutral">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    @if (request()->has('event'))
        <h1 class="text-white mb-3">{{ __('Event #:id Participants', ['id' => request()->query('event')]) }}</h1>
    @endif

    <div class="card">
        @component('admin.components.filter')
            @slot('status', null)

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterEvent">{{ __('Filter Event') }}</label>
                <select class="form-control" name="event" id="filterEvent" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach ($events as $id => $name)
                        <option value="{{ $id }}" @selected(request()->query('event') == $id)>{{ $name }}</option>
                    @endforeach
                </select>
            </div>
        @endcomponent

        <div class="py-4">
            <table id="tableParticipant" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $participant)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Event') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Designation') }}</th>
                        <th>{{ __('Company') }}</th>
                        <th>{{ __('Email') }}</th>
                        <th>{{ __('Phone No.') }}</th>
                        <th>{{ __('Created At') }}</th>
                        {{-- <th>{{ __('Updated At') }}</th> --}}
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Participant',
    'route' => route('participant.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $participant, can: ['update', 'delete']),
        get_dt_column_config('event', 'event.title'),
        get_dt_column_config('name'),
        get_dt_column_config('designation'),
        get_dt_column_config('company'),
        get_dt_column_config('email'),
        get_dt_column_config('contact_no'),
        get_dt_column_config('created_at', searchable: false),
        // get_dt_column_config('updated_at', searchable: false),
    ]
])

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $("#filterEvent").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('event', $(this).val());
            } else {
                urlParams.delete('event');
            }

            window.location.search = urlParams;
        });
    </script>
@endpush
