<?php

namespace Modules\Participant\Policies;

use Modules\Participant\Entities\Participant;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\Admin\Entities\Admin;
use Modules\User\Entities\User;

class ParticipantPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate user can see the participants.
     */
    public function viewAny(Admin|User $auth): bool
    {
        return $auth->hasPermission('participant');
    }

    /**
     * Determine whether the authenticate user can create participants.
     */
    public function create(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the authenticate user can update the participant.
     */
    public function update(Admin|User $auth, Participant $model = null): bool
    {
        return false;
    }

    /**
     * Determine whether the authenticate user can delete the participant.
     */
    public function delete(Admin|User $auth, Participant $model): bool
    {
        return false;
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the admin can export the participants.
     */
    public function export(Admin|User $auth): bool
    {
        return $auth->hasPermission('participant');
    }
}
