<?php

namespace Modules\Participant\Observers;

use Illuminate\Support\Facades\Notification;
use Modules\Participant\Entities\Participant;
use Modules\Participant\Notifications\NewParticipantRegistered;

class ParticipantObserver
{
    /**
     * Handle the model "created" event.
     */
    public function created(Participant $participant): void
    {
        try {
            Notification::route('mail', $participant->email)->notify(new NewParticipantRegistered($participant->loadMissing('event')));
        } catch (\Exception $e) {
            report($e);
        }
    }

    /**
     * Handle the model "updated" event.
     */
    public function updated(Participant $participant): void
    {
        //
    }

    /**
     * Handle the model "deleted" event.
     */
    public function deleted(Participant $participant): void
    {
        $participant->updateQuietly([
            'is_active' => false,
            'deleted_by' => admin()?->id,
        ]);
    }

    /**
     * Handle the model "restored" event.
     */
    public function restored(Participant $participant): void
    {
        $participant->updateQuietly([
            'deleted_by' => null,
        ]);
    }

    /**
     * Handle the model "force deleted" event.
     */
    public function forceDeleted(Participant $participant): void
    {
        //
    }
}
