<?php

namespace Modules\Participant\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Modules\Participant\Entities\Participant;

class NewParticipantRegistered extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(
        protected Participant $participant,
    )
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $event = $this->participant->event;

        return (new MailMessage)
                    ->subject('[' . config('app.name') . '] ' . __('Thank You for Registering Your Interest!'))
                    ->markdown('participant::emails.new-registered-participant', [
                        'participant' => $this->participant,
                        'event' => $event,
                        'link' => $event->file_download_url,
                        'action' => __('Download Event Schedule PDF'),
                    ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
