<?php

namespace Modules\Participant\Exports;

use Illuminate\Http\Request;
use Modules\Participant\Entities\Participant;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ParticipantsExport implements FromQuery, WithMapping, WithHeadings, WithStyles, WithColumnFormatting, ShouldAutoSize
{
    private $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }

    public function headings(): array
    {
        return [
            [
                'id',
                'event_name',
                'participant_name',
                'participant_designation',
                'company_name',
                'email_address',
                'phone_no',
                'created_at',
                // 'updated_at',
            ]
        ];
    }

    public function query()
    {
        $participants = Participant::query()
                        ->with(['event'])
                        ->filters($this->request)
                        ->latest();

        return $participants;
    }

    public function map($participant): array
    {
        return [
            $participant->id,
            $participant->event?->title ?: '-',
            $participant->name,
            $participant->designation,
            $participant->company,
            $participant->email,
            $participant->contact_no,
            Date::dateTimeToExcel($participant->created_at),
            // Date::dateTimeToExcel($participant->updated_at),
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_NUMBER,
            'B' => NumberFormat::FORMAT_TEXT,
            'C' => NumberFormat::FORMAT_TEXT,
            'D' => NumberFormat::FORMAT_TEXT,
            'E' => NumberFormat::FORMAT_TEXT,
            'F' => NumberFormat::FORMAT_TEXT,
            'G' => NumberFormat::FORMAT_TEXT,
            'H' => NumberFormat::FORMAT_DATE_DATETIME,
            // 'I' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }
}
