<?php

namespace Modules\Participant\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Model>
 */
class ParticipantFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\Participant\Entities\Participant::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'name' => $name = fake()->name(),
            'designation' => fake()->catchPhrase(),
            'email' => fake()->unique()->safeEmail,
            'contact_no' => fake()->phoneNumber(),
            'company' => fake()->company(),
        ];
    }
}
