<?php

namespace Modules\Feedback\Transformers;

use Illuminate\Http\Resources\Json\JsonResource;

class FeedbackResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'hash' => $this->hash_id,
            'name' => $this->is_anonymous ? __('Anonymous') : $this->name,
            'message' => $this->message,
            'created_timestamp' => $this->created_at?->timestamp,
            'created_date_formatted' => $this->created_at?->format('d/m/Y'),
            'created_time_formatted' => $this->created_at?->format('h:i A'),
        ];
    }
}
