<?php

use Illuminate\Support\Facades\Route;
use Modules\Feedback\Http\Controllers\AdminController;

Route::prefix('feedback')->name('feedback.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{feedback}/edit', 'edit')->name('edit');
        Route::put('{feedback}', 'update')->name('update');

        Route::delete('{feedback}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});
