@component('mail::message', ['salutation' => $salutation])
# Hello Admin,

There is newly created feedback on an event for your attention to approve it.<br>
The details as per below:

@component('mail::table')
| Details |  |
| --- | --- |
| Event: | {{ $event?->title ?: 'N/A' }} |
| Name: | {{ !$feedback->name || $feedback->is_anonymous ? __('Anonymous') : $feedback->name }} |
| Organisation: | {{ $feedback->organization ?: '-' }} |
| Select Events/Session: | {{ $feedback->session ?: '-' }} |
| Feedback: | {{ $feedback->message }} |
@endcomponent

You also may view more details regarding this new feedback by clicking the button below:<br>

@component('mail::button', ['url' => $link])
{{ $action }}
@endcomponent

@slot('subcopy')
@lang(
    "If you’re having trouble clicking the \":actionText\" button, copy and paste the URL below\n".
    'into your web browser:',
    [
        'actionText' => $action,
    ]
) <span class="break-all">[{{ $link }}]({{ $link }})</span>
@endslot
@endcomponent
