
@inject('feedback', Modules\Feedback\Entities\Feedback::class)

@extends('admin.layouts.base', [
    'title' => __('Feedbacks Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-comments fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('feedback.index') }}">{{ __('Feedbacks') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('feedback.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableFeedback" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $feedback)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Event') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Anonymous') }}</th>
                        <th>{{ __('Organization') }}</th>
                        <th>{{ __('Type') }}</th>
                        <th>{{ __('Feedbacks') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Feedback',
    'route' => route('feedback.trashed'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $feedback, can: ['restore']),
        get_dt_column_config('event', 'event.title'),
        get_dt_column_config('name', default: 'Anonymous'),
        get_dt_column_config('anonymous', 'is_anonymous', searchable: false),
        get_dt_column_config('organization'),
        get_dt_column_config('session'),
        get_dt_column_config('message'),
        get_dt_column_config('status'),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
