
@inject('feedback', Modules\Feedback\Entities\Feedback::class)

@extends('admin.layouts.base', [
    'title' => __('Feedbacks Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-comments fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('feedback.index') }}">{{ __('Feedbacks') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $feedback)
                <a href="{{ route('feedback.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $feedback)
                <a href="{{ route('feedback.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    @if (request()->has('event'))
        <h1 class="text-white mb-3">{{ __('Event #:id Feedbacks', ['id' => request()->query('event')]) }}</h1>
    @endif

    <div class="card">
        @component('admin.components.filter')
            @slot('status', null)

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterEvent">{{ __('Filter Event') }}</label>
                <select class="form-control" name="event" id="filterEvent" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach ($events as $id => $name)
                        <option value="{{ $id }}" @selected(request()->query('event') == $id)>{{ $name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterStatus">{{ __('Filter Status') }}</label>
                <select class="form-control" name="status" id="filterStatus" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach ($feedback::listStatuses() as $label)
                        <option value="{{ $label }}" @selected(request()->query('status') == $label)>{{ ucwords($label) }}</option>
                    @endforeach
                </select>
            </div>

            <div class="px-3 py-2">
                <label class="form-control-label" for="filterAnonymous">{{ __('Filter Anonymous') }}</label>
                <select class="form-control" name="anonymous" id="filterAnonymous" data-toggle="select">
                    <option value="all">{{ __('All') }}</option>
                    @foreach (['yes', 'no'] as $label)
                        <option value="{{ $label }}" @selected(request()->query('anonymous') == $label)>{{ ucwords($label) }}</option>
                    @endforeach
                </select>
            </div>
        @endcomponent

        <div class="py-4">
            <table id="tableFeedback" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $feedback)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Event') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Anonymous') }}</th>
                        <th>{{ __('Organization') }}</th>
                        <th>{{ __('Events/Session') }}</th>
                        <th>{{ __('Feedbacks') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        {{-- <th>{{ __('Updated At') }}</th> --}}
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Feedback',
    'route' => route('feedback.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $feedback, can: ['update', 'delete']),
        get_dt_column_config('event', 'event.title'),
        get_dt_column_config('name', default: 'Anonymous'),
        get_dt_column_config('anonymous', 'is_anonymous', searchable: false),
        get_dt_column_config('organization'),
        get_dt_column_config('session'),
        get_dt_column_config('message'),
        get_dt_column_config('status'),
        get_dt_column_config('created_at', searchable: false),
        // get_dt_column_config('updated_at', searchable: false),
    ]
])

@push('js')
    <script nonce="{{ csp_nonce('script') }}">
        $("#filterEvent").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('event', $(this).val());
            } else {
                urlParams.delete('event');
            }

            window.location.search = urlParams;
        });

        $("#filterStatus").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('status', $(this).val());
            } else {
                urlParams.delete('status');
            }

            window.location.search = urlParams;
        });

        $("#filterAnonymous").on('change', function (ev) {
            const urlParams = new URLSearchParams(window.location.search);

            if ($(this).val() != 'all') {
                urlParams.set('anonymous', $(this).val());
            } else {
                urlParams.delete('anonymous');
            }

            window.location.search = urlParams;
        });
    </script>
@endpush
