<div class="col-12 form-group">
    <label class="form-control-label" for="input-event">{{ __('Event') }}</label>
    <select name="event" id="input-event" class="form-control {{ $errors->has('event') ? 'is-invalid' : '' }}" placeholder="{{ __('Please Select Event') }}" data-toggle="select" disabled>
        <option value="">{{ __('Please Select Event') }}</option>
        @foreach ($events as $id => $title)
            <option value="{{ $id }}" @selected(old('event', $feedback->event_id) == $id)>{{ $title }}</option>
        @endforeach
    </select>
    @include('alerts.feedback', ['field' => 'event'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-name">{{ __('Name') }}</label>
    <div class="{{ $errors->has('name') ? 'has-danger' : '' }}">
        <input type="text" name="name" id="input-name" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="{{ __('Name') }}" value="{{ old('name', $feedback->name ?: 'Anonymous') }}" readonly>
    </div>
    @include('alerts.feedback', ['field' => 'name'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-organization">{{ __('Organisation') }}</label>
    <div class="{{ $errors->has('organization') ? 'has-danger' : '' }}">
        <input type="text" name="organization" id="input-organization" class="form-control {{ $errors->has('organization') ? 'is-invalid' : '' }}" placeholder="{{ __('Organisation') }}" value="{{ old('organization', $feedback->organization ?: '-') }}" readonly>
    </div>
    @include('alerts.feedback', ['field' => 'organization'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-session">{{ __('Events/Session') }}</label>
    <div class="{{ $errors->has('session') ? 'has-danger' : '' }}">
        <input type="text" name="session" id="input-session" class="form-control {{ $errors->has('session') ? 'is-invalid' : '' }}" placeholder="{{ __('Select Events/Session') }}" value="{{ old('session', $feedback->session ?: '-') }}" readonly>
    </div>
    @include('alerts.feedback', ['field' => 'session'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-message">{{ __('Feedback') }}</label>
    <div class="{{ $errors->has('message') ? 'has-danger' : '' }}">
        <textarea name="message" id="input-message" class="form-control {{ $errors->has('message') ? 'is-invalid' : '' }}" cols="30" rows="5" readonly>{{ old('message', $feedback->message ?: 'N/A') }}</textarea>
    </div>
    @include('alerts.feedback', ['field' => 'message'])
</div>

<div class="col-12 form-group">
    <label class="form-control-label" for="input-status">{{ __('Status') }} <sup class="text-danger">*</sup></label>
    <select name="status" id="input-status" class="form-control {{ $errors->has('status') ? 'is-invalid' : '' }}" placeholder="{{ __('Please Select Status') }}" data-toggle="select" required>
        <option value="">{{ __('Please Select Status') }}</option>
        @foreach ($feedback::listStatuses() as $label)
            <option value="{{ $label }}" @selected(old('status', $feedback->status ?: $feedback::STATUS_PENDING) == $label)>{{ ucwords($label) }}</option>
        @endforeach
    </select>
    @include('alerts.feedback', ['field' => 'status'])
</div>

@push('vendor-css')
    <link rel="stylesheet" href="{{ basset_url('argon/vendor/select2/dist/css/select2.min.css') }}" nonce="{{ csp_nonce('style') }}">
@endpush

@push('vendor-js')
    <script src="{{ basset_url('argon/vendor/select2/dist/js/select2.full.min.js') }}" nonce="{{ csp_nonce('script') }}"></script>
@endpush
