<?php

namespace Modules\Feedback\Policies;

use Modules\Feedback\Entities\Feedback;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\Admin\Entities\Admin;
use Modules\User\Entities\User;

class FeedbackPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate user can see the feedbacks.
     */
    public function viewAny(Admin|User $auth): bool
    {
        return $auth->hasPermission('feedback');
    }

    /**
     * Determine whether the authenticate user can create feedbacks.
     */
    public function create(Admin|User $auth): bool
    {
        return false;
    }

    /**
     * Determine whether the authenticate user can update the feedback.
     */
    public function update(Admin|User $auth, Feedback $model = null): bool
    {
        return $auth->hasPermission('feedback');
    }

    /**
     * Determine whether the authenticate user can delete the feedback.
     */
    public function delete(Admin|User $auth, Feedback $model): bool
    {
        return $auth->hasPermission('feedback');
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|User $auth): bool
    {
        return $auth->hasPermission('feedback');
    }

    /**
     * Determine whether the admin can export the feedbacks.
     */
    public function export(Admin|User $auth): bool
    {
        return false;
    }
}
