<?php

namespace Modules\Feedback\Observers;

use App\Model\Setting;
use Illuminate\Support\Facades\Notification;
use Modules\Feedback\Entities\Feedback;
use Modules\Feedback\Notifications\NewFeedbackCreated;

class FeedbackObserver
{
    /**
     * Handle the model "created" event.
     */
    public function created(Feedback $feedback): void
    {
        try {
            $admins = Setting::getAdminNotifyEmails();

            if (count($admins)) {
                Notification::route('mail', $admins)->notify(new NewFeedbackCreated($feedback->loadMissing('event')));
            }
        } catch (\Exception $e) {
            report($e);
        }
    }

    /**
     * Handle the model "updated" event.
     */
    public function updated(Feedback $feedback): void
    {
        //
    }

    /**
     * Handle the model "deleted" event.
     */
    public function deleted(Feedback $feedback): void
    {
        $feedback->updateQuietly([
            'status' => Feedback::STATUS_DISABLED,
            'deleted_by' => admin()?->id,
        ]);
    }

    /**
     * Handle the model "restored" event.
     */
    public function restored(Feedback $feedback): void
    {
        $feedback->updateQuietly([
            'deleted_by' => null,
        ]);
    }

    /**
     * Handle the model "force deleted" event.
     */
    public function forceDeleted(Feedback $feedback): void
    {
        //
    }
}
