<?php

namespace Modules\Feedback\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Modules\Feedback\Entities\Feedback;

class NewFeedbackCreated extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(
        protected Feedback $feedback,
    )
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->subject('[' . config('app.name') . '] ' . __('New Event Feedback Pending For Approval'))
                    ->markdown('feedback::emails.new-pending-feedback', [
                        'salutation' => __('Thank you.'),
                        'feedback' => $this->feedback,
                        'event' => $this->feedback->event,
                        'link' => route('feedback.edit', $this->feedback),
                        'action' => __('View Feedback'),
                    ]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
