<?php

namespace Modules\Feedback\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Feedback\Entities\Feedback;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Model>
 */
class FeedbackFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\Feedback\Entities\Feedback::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'name' => fake()->name(),
            'message' => fake()->realText(),
            'status' => fake()->randomElement(Feedback::listStatuses()),
            'is_anonymous' => fake()->boolean(),
        ];
    }
}
