<?php

use Illuminate\Support\Facades\Route;
use Modules\Example\Http\Controllers\AdminController;

Route::prefix('example')->name('example.')->group(function () {
    Route::controller(AdminController::class)->group(function () {
        Route::get('/', 'index')->name('index');

        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');

        Route::get('{example}/edit', 'edit')->name('edit');
        Route::put('{example}', 'update')->name('update');

        Route::delete('{example}', 'destroy')->name('destroy');

        Route::get('trashed', 'trashed')->name('trashed');
        Route::post('restore/{id}', 'restore')->name('restore');

        Route::get('export', 'export')->name('export');
    });
});