
@inject('example', Modules\Example\Entities\Example::class)

@extends('admin.layouts.base', [
    'title' => __('Examplies Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-icons fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('example.index') }}">{{ __('Examplies') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('example.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableExample" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $example)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Example',
    'route' => route('example.trashed'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $example, can: ['restore']),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
