
@inject('example', Modules\Example\Entities\Example::class)

@extends('admin.layouts.base', [
    'title' => __('Examplies Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-icons fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('example.index') }}">{{ __('Examplies') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $example)
                <a href="{{ route('example.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $example)
                <a href="{{ route('example.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="position-relative container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', null)
        @endcomponent

        <div class="py-4">
            <table id="tableExample" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $example)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Example',
    'route' => route('example.index'),
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $example, can: ['update', 'delete']),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])
