@extends('admin.layouts.base', [
    'title' => __('Edit Example'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-icons fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('example.index') }}">{{ __('Examplies') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>

        @slot('buttons')
            <a href="{{ route('example.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Example') . ' #' . $example->id)
                    @slot('route', route('example.update', $example->hash_id))

                    @include('example::admin.form', ['example' => $example, 'edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
