<?php

namespace Modules\Example\Policies;

use Modules\Example\Entities\Example;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\Admin\Entities\Admin;
use Modules\User\Entities\User;

class ExamplePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate user can see the examplies.
     */
    public function viewAny(Admin|User $auth): bool
    {
        return $auth->hasPermission('example');
    }

    /**
     * Determine whether the authenticate user can create examplies.
     */
    public function create(Admin|User $auth): bool
    {
        return $auth->hasPermission('example');
    }

    /**
     * Determine whether the authenticate user can update the example.
     */
    public function update(Admin|User $auth, Example $model = null): bool
    {
        return $auth->hasPermission('example');
    }

    /**
     * Determine whether the authenticate user can delete the example.
     */
    public function delete(Admin|User $auth, Example $model): bool
    {
        return $auth->hasPermission('example');
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|User $auth): bool
    {
        return $auth->hasPermission('example');
    }

    /**
     * Determine whether the admin can export the examplies.
     */
    public function export(Admin|User $auth): bool
    {
        return false;
    }
}
