<?php

namespace Modules\Example\Http\Requests;

use Modules\Example\Entities\Example;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class ExampleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        // $example = $this->route()->example;

        return [
            'thumbnail' => file_validation($this->get('thumbnail')),
            'is_active' => ['sometimes', 'boolean'],
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'is_active' => 'status active'
        ];
    }
}
